SET SESSION explicit_defaults_for_timestamp = 1;

-- внешние учетные записи юзера
CREATE TABLE profile (
    profile_id   BIGINT   UNSIGNED NOT NULL AUTO_INCREMENT, -- внутренний, уникальный идентификатор учётной записи, к которому привязываюся токены, подписки и профиль
    uid          BIGINT   UNSIGNED NOT NULL, -- внутренний идентификатор пользователя
    provider_id  TINYINT  UNSIGNED NOT NULL, -- идентификатор провайдера из конфига providers.yaml
    userid       VARCHAR(255)      NOT NULL, -- внешний, постоянный, уникальный идентификатор учётной записи у провайдера (обычной цифровой)
    username     VARCHAR(255)      NOT NULL DEFAULT '', -- внешний, потенциально изменяемый, уникальный идентификатор учётной записи у провайдера в читабельном виде (screen_name/nickname/login/slug у провайдера)
    allow_auth   TINYINT  UNSIGNED NOT NULL DEFAULT 0,
    created      TIMESTAMP         NOT NULL DEFAULT CURRENT_TIMESTAMP, -- время создания
    verified     TIMESTAMP         NOT NULL DEFAULT '0000-00-00 00:00:00',
    confirmed    TIMESTAMP         NOT NULL DEFAULT '0000-00-00 00:00:00',
    referer      MEDIUMINT UNSIGNED NOT NULL DEFAULT 0, -- цифровой идентификатор потребителя, который привёл к нам этот профиль
    yandexuid    VARCHAR(40)       NOT NULL DEFAULT '',
    PRIMARY KEY  (profile_id),
    UNIQUE KEY   (provider_id, userid, uid),  -- аккаунт должен быть уникален в пределах записей пользователя для одного и того же провайдера
    KEY          (uid)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- персональная информация, указанная пользователем провайдеру
CREATE TABLE person (
    profile_id   BIGINT   UNSIGNED   NOT NULL,
    firstname    VARCHAR(255)        NOT NULL DEFAULT '',
    lastname     VARCHAR(255)        NOT NULL DEFAULT '',
    nickname     VARCHAR(255)        NOT NULL DEFAULT '',
    gender       ENUM ('', 'm', 'f') NOT NULL DEFAULT '',
    birthday     DATE                NOT NULL DEFAULT '0000-00-00',
    email        VARCHAR(255)        NOT NULL DEFAULT '',
    phone        VARCHAR(255)        NOT NULL DEFAULT '',
    country      VARCHAR(255)        NOT NULL DEFAULT '',
    city         VARCHAR(255)        NOT NULL DEFAULT '',
    PRIMARY KEY  (profile_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- список учётных записей, видимых определенному яндекс-сервису
CREATE TABLE subscription (
    profile_id   BIGINT   UNSIGNED NOT NULL, -- внутренний идентификатор учётной записи из таблицы profile
    sid          SMALLINT UNSIGNED NOT NULL, -- идентификатор яндекс-сервиса
    value        TINYINT  UNSIGNED NOT NULL DEFAULT 1, -- флаг наличия подписки
    PRIMARY KEY  (profile_id, sid)           -- у одного сервиса может быть только одна подписка на аккаунт
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- токены к учётной записи
CREATE TABLE token (
    token_id        BIGINT  UNSIGNED NOT NULL AUTO_INCREMENT,
    uid             BIGINT  UNSIGNED NOT NULL,
    profile_id      BIGINT  UNSIGNED DEFAULT NULL, -- внутренний идентификатор учётной записи из таблицы profile
    application_id  MEDIUMINT UNSIGNED NOT NULL, -- идентификатор приложения из конфига applications.yaml
    value           VARCHAR(2048)    NOT NULL, -- значение токена
    secret          VARCHAR(255)     NOT NULL DEFAULT '', -- secret-часть токена (опциональная)
    scope           VARCHAR(255)     NOT NULL DEFAULT '', -- строка разрешений, выданных токену, перечисленных через пробел
    expired         TIMESTAMP        NOT NULL DEFAULT '0000-00-00 00:00:00',
    created         TIMESTAMP        NOT NULL DEFAULT CURRENT_TIMESTAMP, -- время создания
    verified        TIMESTAMP        NOT NULL DEFAULT '0000-00-00 00:00:00',
    confirmed       TIMESTAMP        NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY     (token_id),
    UNIQUE KEY      (uid, application_id, value),
    KEY             (profile_id, application_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ключи для подписывания куки broker_session
CREATE TABLE `key` (
    key_id          BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    value           CHAR(64)        NOT NULL,
    PRIMARY KEY     (key_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE business_application_map (
    id             BIGINT   UNSIGNED NOT NULL AUTO_INCREMENT,
    business_id    TINYINT  UNSIGNED NOT NULL DEFAULT 0,
    business_token VARCHAR(255)      NOT NULL DEFAULT '',
    application_id MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,
    userid         VARCHAR(255)      NOT NULL DEFAULT '',
    ts             TIMESTAMP         NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    UNIQUE  KEY (business_id, business_token, application_id, userid),
    KEY         (userid, application_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- рефреш токены для токенов
CREATE TABLE refresh_token (
    refresh_token_id BIGINT UNSIGNED  NOT NULL AUTO_INCREMENT,
    value            VARCHAR(2048)    NOT NULL,
    token_id         BIGINT UNSIGNED  NOT NULL,
    expired          TIMESTAMP        NOT NULL,
    PRIMARY KEY      (refresh_token_id),
    UNIQUE KEY       (token_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- атрибуты приложений, на которые нужны ограничения униальности и индекс
CREATE TABLE application (
  application_id     BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  provider_id        TINYINT UNSIGNED DEFAULT NULL,
  provider_client_id VARCHAR(512) NOT NULL,
  application_name   VARCHAR(160) NOT NULL,
  PRIMARY KEY        (application_id),
  UNIQUE KEY         (application_name),
  UNIQUE KEY         (provider_id, provider_client_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- атрибуты приложений, на которые нужен индекс
CREATE TABLE application_index_attribute (
  application_id BIGINT UNSIGNED NOT NULL,
  `type`         SMALLINT UNSIGNED NOT NULL,
  value          VARCHAR(160) DEFAULT NULL,
  PRIMARY KEY    (application_id, `type`),
  KEY            (`type`, value)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- остальные атрибуты приложений
CREATE TABLE application_attribute (
  application_id BIGINT UNSIGNED NOT NULL,
  `type`         SMALLINT UNSIGNED NOT NULL,
  value          VARCHAR(2048) NOT NULL,
  PRIMARY KEY    (application_id,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
