# -*- coding: utf-8 -*-

from passport.backend.social.common.exception import NotErrorFailureSourceTypeMixin


class ProxyError(Exception):
    type = 'external'
    code = ''
    description = ''


class InternalError(ProxyError):
    type = 'internal'
    code = 'internal_error'
    description = 'Something went wrong'


class TokensNotFoundError(NotErrorFailureSourceTypeMixin, ProxyError):
    description = 'There are no tokens for the profile'
    code = 'no_tokens_found'


class ProfileNotFoundError(NotErrorFailureSourceTypeMixin, ProxyError):
    description = 'Profile not found'
    code = 'profile_not_found'


class TaskNotFoundError(NotErrorFailureSourceTypeMixin, ProxyError):
    description = 'Task not found'
    code = 'task_not_found'


class InvalidTaskError(NotErrorFailureSourceTypeMixin, ProxyError):
    description = 'Task can not be used with proxy'
    code = 'task_invalid'


class InvalidParametersError(NotErrorFailureSourceTypeMixin, ProxyError):
    description = 'Some passed parameters are missing or invalid'
    code = 'invalid_parameters'


class RateLimitExceededError(NotErrorFailureSourceTypeMixin, ProxyError):
    code = 'rate_limit_exceeded'

    def __init__(self, description, message=''):
        super(RateLimitExceededError, self).__init__(message)
        self.description = description


class GrantsMissingError(NotErrorFailureSourceTypeMixin, ProxyError):
    code = 'access_denied'

    def __init__(self, description, message=''):
        super(GrantsMissingError, self).__init__(message)
        self.description = description


class ProxyMethodNotImplementedError(NotErrorFailureSourceTypeMixin, ProxyError):
    code = 'not_implemented_error'
    description = 'Method for provider is not implemented'
