# -*- coding: utf-8 -*-

import logging
import os
from os import path
import sys

from passport.backend.social.common.context import request_ctx
from passport.backend.social.common.social_logging import (
    close_logging_handlers,
    ExceptionFormatter,
    SocialFormatter,
    WarningFormatter,
)
import yenv


DEBUG = yenv.type == 'development'

root_handlers = {'proxy', 'proxy.error', 'proxy.exception', 'proxy.warning'}
subprocess_handlers = {'proxy.subprocess.error'}
if not os.environ.get('SYSTEM_WIDE_SOCIAL_PROXY2'):
    root_handlers.add('console')
    subprocess_handlers.add('console')

if os.environ.get('SYSTEM_WIDE_SOCIAL_PROXY2'):
    LOG_PATH = '/var/log/yandex/socialism'
else:
    LOG_PATH = '.'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': SocialFormatter,
            'context': request_ctx,
        },
        'exception': {
            '()': ExceptionFormatter,
            'context': request_ctx,
            'logtype': 'social-proxy2-exception-log',
        },
        'warning': {
            '()': WarningFormatter,
            'context': request_ctx,
            'logtype': 'social-proxy2-warning-log',
        },
        'simple': {
            'format': "%(message)s"
        },
    },
    'root': {
        'handlers': root_handlers,
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'stream': sys.stdout,
            'level': 'DEBUG',
            'formatter': 'default',
        },
        'proxy': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-proxy2.debug.log'),
            'formatter': 'default',
            'level': 'DEBUG',
        },
        'proxy.error': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-proxy2.error.log'),
            'formatter': 'default',
            'level': 'ERROR',
        },
        'proxy.exception': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-proxy2.exception.log'),
            'formatter': 'exception',
            'level': 'ERROR',
            'filters': ['exception_filter'],
        },
        'proxy.warning': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-proxy2.warning.log'),
            'formatter': 'warning',
            'filters': ['warning_filter'],
        },
        'proxy.subprocess.error': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-proxy2.subprocess.error.log'),
            'formatter': 'default',
            'level': 'DEBUG',
        },
        'access': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-proxy2.access.log'),
            'formatter': 'simple',
        },
        'statbox_friends': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-friends.statbox.log'),
            'formatter': 'simple',
        },
        'graphite': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-proxy2.graphite.log'),
            'formatter': 'simple',
        },
    },
    'filters': {
        'exception_filter': {
            '()': 'passport.backend.social.common.social_logging.ExceptionFilter',
        },
        'warning_filter': {
            '()': 'passport.backend.social.common.social_logging.LevelFilter',
            'levels': ['WARNING'],
        },
    },
    'loggers': {
        'subprocess.error': {
            'handlers': subprocess_handlers,
            'propagate': False,
        },
        'access': {
            'handlers': ['access'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'urllib3': {
            'level': logging.INFO,
        },
        'statbox_friends': {
            'handlers': ['statbox_friends'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'graphite.database': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'graphite.useragent': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'graphite.redis': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.backend.social.common._urllib3': {'level': 'WARNING'},
        'passport.backend.social.common.db.execute': {'level': 'WARNING'},
        'passport.backend.social.common.useragent': {'level': 'INFO'},

        # блок конфигурации для билдеров
        'passport.kolmogor': {
            'handlers': ['proxy'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
}


def logging_settings_deinit():
    close_logging_handlers(LOGGING)
