# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging

from flask import request
from passport.backend.social.common.db.execute import execute
from passport.backend.social.common.db.utils import get_slave_engine
from passport.backend.social.common.exception import NetworkProxylibError
from passport.backend.social.common.misc import (
    format_traceback,
    GraphiteMessageType,
    write_graph_log_message,
)
from passport.backend.social.common.multiprocessing import execute_multiple_methods
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.web_service import Response
from passport.backend.social.proxylib import useragent


logger = logging.getLogger(__name__)


def ping_view():
    def append_error(error):
        errors.append(error)
        # Смысл пинга сообщить о здоровье приложения, не следует каждый раз
        # когда что-то не в порядке писать в лог с ошибками. Но для
        # расследования лучше всё-таки сохранить диагностику в информационном
        # журнале.
        logger.info('Error while pinging service %s: %s', error, format_traceback())

    check = request.args.get('check')
    if not check:
        return Response('Error: "check" parameter should be specified\n', status=400, mimetype='application/json')

    try:
        fd = open(social_config.ping_file_path, 'r')
        fd.read(100)
        fd.close()
    except Exception:
        data = json.dumps({'errors': [social_config.ping_file_path]})
        return Response(data, status=503, mimetype='application/json')

    check = check.split(',')
    errors = []
    jobs = []

    def _check_db():
        try:
            execute(get_slave_engine(), 'select 1;')
        except:
            append_error('db')

    def _check_social_api():
        try:
            response = useragent.execute_request(
                method='GET',
                url='http://127.0.0.1/api/ping',
                headers={'Host': social_config.social_api_host},
                retries=2,
                timeout=0.5,
                service='social_api',
            )
            if response.decoded_data.lower().strip() != 'pong':
                raise Exception('Response != pong. %s' % response.decoded_data)
        except NetworkProxylibError:
            write_graph_log_message(GraphiteMessageType.error, 'ping', 'social_api', 'network')
            append_error('social_api')
        except:
            append_error('social_api')

    if 'db' in check:
        jobs.append(_check_db)

    if 'social_api' in check:
        jobs.append(_check_social_api)

    execute_multiple_methods(jobs)

    if errors:
        data = json.dumps({'errors': errors})
        return Response(data, status=503, mimetype='application/json')

    return Response('Pong\n', status=200)
