# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.social.common.chrono import now


class StatboxLogEntry(TskvLogEntry):
    def __init__(self, **params):
        params.setdefault('tskv_format', 'social-proxy2-log')
        params.setdefault('unixtime', now.i())
        super(StatboxLogEntry, self).__init__(**params)


class FriendsStatboxLogEntry(StatboxLogEntry):
    @staticmethod
    def truncate_str(text):
        # Списки друзей очень длинные и резать их нельзя
        return text


class StatboxFriendsLogger(TskvLogger):
    default_logger_name = 'statbox_friends'
    entry_class = FriendsStatboxLogEntry
