# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from functools import partial

from flask import request
from passport.backend.social.common.web_service import (
    ExternalHandler,
    Response,
)


class BaseProxyExternalHandler(ExternalHandler):
    _response_class = Response

    @classmethod
    def as_view(cls):
        view_func = partial(cls._view_func, cls)
        view_func.__name__ = cls.__name__
        return view_func

    @staticmethod
    def _view_func(cls, *args, **kwargs):
        handler = cls(request)
        return handler.get(*args, **kwargs)
