# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from .proxy import SocialProxy
from .repo.common import Repo


def build_application_only_proxy(app):
    # Т.к. в проекте наличие у прокси какой-либо способности проверяется
    # функцией getattr, то для приложений без провайдера придётся строить класс
    # прокси динамически.

    class_attrs = dict(SETTINGS=dict())

    if app.refresh_token_url:
        class_attrs['SETTINGS'].update(dict(oauth_refresh_token_url=app.refresh_token_url))
        class_attrs['refresh_token'] = _refresh_token_method

    class_name = 'ApplicationOnlyProxyFor%d' % app.identifier

    return type(class_name.encode('ascii'), (_ApplicationOnlyProxy,), class_attrs)()


class _ApplicationOnlyProxy(SocialProxy):
    def __init__(self):
        super(_ApplicationOnlyProxy, self).__init__()
        self.r = Repo(code=None)


def _refresh_token_method(self, refresh_token):
    return self._refresh_token(refresh_token)
