# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.providers.Deezer import Deezer

from . import mapper
from .proxy import SocialProxy


class DeezerProxy(SocialProxy):
    code = Deezer.code

    SETTINGS = {
        'userinfo': 'https://api.deezer.com/user/me',
        'albums': 'https://api.deezer.com/user/me/albums',

        'birthday_regexp': r'^(?P<year>\d{4})-(?P<month>\d{1,2})-(?P<day>\d{1,2})$',
        'gender_map': {'M': 'm', 'F': 'f'},

        # Комментарии к кодам ошибок: https://developers.deezer.com/api/errors
        'error_rate_limit_exceeded': {4},
        'error_codes_invalid_token': {300},
        'error_codes_permission': {200, 201},
    }

    PROFILE_MAPPING = {
        'id': 'userid',
        'name': 'username',
        'email': 'email',
        'firstname': 'firstname',
        'lastname': 'lastname',
        'birthday': 'birthday',
        'gender': 'gender',
    }

    def get_profile(self):
        self.r.compose_request(url_name='userinfo')
        self.r.execute_request_basic()
        self.r.deserialize_json()
        self.r.parse_error_response()
        self.r.extract_response_data(
            self.PROFILE_MAPPING,
            one=True,
            listed=False,
        )

        data = self.r.context['processed_data']
        data['userid'] = str(data['userid'])

        self.r.convert_birthday()
        self.r.convert_gender()
        return self.r.context['processed_data']


mapper.add_mapping(DeezerProxy.code, DeezerProxy)
