# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.core.models.account import Account
from passport.backend.social.common.builders.blackbox import (
    Blackbox,
    BlackboxInvalidResponseError,
    BlackboxInvalidSessionidError,
    BlackboxTemporaryError,
    BlackboxUnknownError,
    check_session_cookie,
)
from passport.backend.social.common.exception import (
    InternalProxylibError,
    InvalidTokenProxylibError,
    ProviderTemporaryUnavailableProxylibError,
)
from passport.backend.social.common.providers.Kinopoisk import Kinopoisk
from passport.backend.social.common.useragent import get_http_pool_manager
from passport.backend.social.proxylib import mapper
from passport.backend.social.proxylib.proxy import SocialProxy


class KinopoiskProxy(SocialProxy):
    code = Kinopoisk.code

    SETTINGS = {
    }

    def __init__(self, *args, **kwargs):
        super(KinopoiskProxy, self).__init__(*args, **kwargs)
        self.blackbox = Blackbox(get_http_pool_manager())

    def _get_userid_by_session_id(self):
        session_id = self.r.access_token['value']
        user_ip = self.r.aux_data['user_ip']
        try:
            blackbox_response = self.blackbox.sessionid(sessionid=session_id, host='kinopoisk.ru', ip=user_ip, attributes=[], dbfields=[])
        except BlackboxTemporaryError:
            raise ProviderTemporaryUnavailableProxylibError('Getting kinopoisk account failed: network fail')
        except (BlackboxInvalidResponseError, BlackboxUnknownError):
            raise InternalProxylibError('Getting kinopoisk account failed: blackbox fail')

        try:
            check_session_cookie(blackbox_response)
        except BlackboxInvalidSessionidError:
            raise InvalidTokenProxylibError('Getting kinopoisk account failed: invalid session id')

        kinopoisk_account = Account().parse(blackbox_response)
        return kinopoisk_account.uid

    def get_profile(self):
        userid = self._get_userid_by_session_id()
        return {
            'userid': userid,
        }


mapper.add_mapping(KinopoiskProxy.code, KinopoiskProxy)
