# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.exception import InvalidTokenProxylibError
from passport.backend.social.common.providers.Meethue import (
    Meethue,
    meethue_authorization_header,
)

from . import mapper
from .proxy import SocialProxy


class MeethueProxy(SocialProxy):
    code = Meethue.code

    SETTINGS = {
        'oauth_refresh_token_url': 'https://api.meethue.com/oauth2/refresh',
    }

    def _parse_and_detect_error(self):
        self.r.deserialize_json()

        if 'ErrorCode' in self.r.context['data']:
            raise InvalidTokenProxylibError()

    def refresh_token(self, refresh_token):
        headers = {
            'Authorization': meethue_authorization_header(self.r.app.id, self.r.app.secret),
        }

        self.r.compose_request(
            url_name='oauth_refresh_token_url',
            data={
                'grant_type': 'refresh_token',
                'client_id': self.r.app.id,
                'client_secret': self.r.app.secret,
                'refresh_token': refresh_token,
            },
            add_access_token=False,
            additional_headers=headers,
        )

        self.r.execute_request_basic(parser=self._parse_and_detect_error)
        self._parse_and_detect_error()

        self.r.extract_response_data(
            {
                'access_token': 'access_token',
                'access_token_expires_in': 'expires_in',
                'refresh_token': 'refresh_token',
            },
            one=True,
            listed=False,
        )

        expires_in = self.r.context['processed_data'].get('expires_in')
        if expires_in:
            expires_in = int(expires_in)
            self.r.context['processed_data']['expires_in'] = expires_in

        return self.r.context['processed_data']


mapper.add_mapping(MeethueProxy.code, MeethueProxy)
