# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.common import oauth2
from passport.backend.social.common.misc import trim_message
from passport.backend.social.common.providers.MosRu import MosRu
from passport.backend.social.common.social_config import social_config
from passport.backend.social.proxylib import mapper
from passport.backend.social.proxylib.proxy import SocialProxy


logger = logging.getLogger(__name__)


class MosRuProxy(SocialProxy):
    code = MosRu.code

    @property
    def SETTINGS(self):
        return {
            'get_profile_url': social_config.mos_ru_get_profile_url,
            'error_codes_invalid_token': {401},
            'oauth_refresh_token_url': social_config.mos_ru_refresh_token_url,
            'oauth_auth_over_header': True,
        }

    PROFILE_MAPPING = {
        'guid': 'userid',
        'FirstName': 'firstname',
        'LastName': 'lastname',
    }

    def get_profile(self):
        self.r.compose_request(url_name='get_profile_url')
        self.r.execute_request_basic()
        logger.debug('Profile response %s' % trim_message(
            self.r.context['raw_response'].decoded_data))
        self.r.parse_error_response()
        self.r.deserialize_json()
        self.r.extract_response_data(self.PROFILE_MAPPING, listed=False, one=True)
        return self.r.context['processed_data']

    def refresh_token(self, refresh_token):
        return self._refresh_token(
            refresh_token, self._detect_refresh_token_error, auth_type_is_basic=True)

    def _detect_refresh_token_error(self, response):
        try:
            oauth2.refresh_token.detect_error(response)
        except oauth2.refresh_token.InvalidRequest as e:
            raise oauth2.refresh_token.InvalidGrant.from_exception(e)


mapper.add_mapping(MosRuProxy.code, MosRuProxy)
