# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.providers.MtsBelarus import MtsBelarus

from . import mapper
from .proxy import SocialProxy


class MtsBelarusProxy(SocialProxy):
    code = MtsBelarus.code

    SETTINGS = {
        'api_url': 'https://auth-music.mts.by/api/v1/%(method)s',
        'oauth_auth_over_header': True,
        'error_codes_invalid_token': {401},
    }

    PROFILE_MAPPING = {
        'id': 'personal_id',
        'msisdn': 'phone',
    }

    def get_profile(self):
        self.r.compose_request(url_name='api_url', method='info')
        self.r.execute_request_basic()
        self.r.parse_error_response()
        self.r.deserialize_json()
        self.r.extract_response_data(
            self.PROFILE_MAPPING,
            converter=self.r.convert_profile,
            listed=False,
            one=True,
        )
        return self.r.context['processed_data']


mapper.add_mapping(MtsBelarusProxy.code, MtsBelarusProxy)
