# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common import oauth2
from passport.backend.social.common.exception import InvalidTokenProxylibError
from passport.backend.social.common.providers.Xiaomi import Xiaomi

from . import mapper
from .proxy import SocialProxy


OA_INVALID_REFRESHTOKEN = 96009


class XiaomiProxy(SocialProxy):
    code = Xiaomi.code

    @property
    def SETTINGS(self):
        return {
            'oauth_refresh_token_url': self.r.app.refresh_token_url,
        }

    def _detect_error(self, response):
        if response.get('error') == OA_INVALID_REFRESHTOKEN:
            raise InvalidTokenProxylibError()
        return oauth2.refresh_token.detect_error(response)

    def refresh_token(self, refresh_token):
        return super(XiaomiProxy, self)._refresh_token(refresh_token, detect_error=self._detect_error)


mapper.add_mapping(XiaomiProxy.code, XiaomiProxy)
