# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.application import ApplicationGroupId
from passport.backend.social.common.exception import ProviderUnknownProxylibError
from passport.backend.social.common.misc import ApplicationMapper
from passport.backend.social.common.provider_settings import providers

from .ApplicationOnlyProxy import build_application_only_proxy
from .repo import get_repo


def get_proxy(code=None, access_token=None, app=None, aux_data=None,
              should_retry_on_invalid_token=False):
    """
    Создать новый объект SocialProxy от соответствующей соц сети.
    Можно сразу передать access_token и объект приложения.
    aux_data - дополнительные данные, которые могут быть использованы разными ручками.
    """
    assert code or app

    # Чтобы можно было не передавать в функцию code, когда уже известно app
    if not code and app and app.provider:
        code = app.provider['code']

    if code:
        if not mapper.has_provider(code):
            raise ProviderUnknownProxylibError('Proxy for provider %s not found' % code)

        proxy = mapper[(code, app)]()
        proxy.r = get_repo(code)
    else:
        proxy = build_application_only_proxy(app)

    if access_token:
        proxy.parse_raw_token(access_token)

    proxy.r.app = app
    proxy.r.aux_data = aux_data or {}
    proxy.r.should_retry_on_invalid_token = should_retry_on_invalid_token

    if app and app.group_id == ApplicationGroupId.station:
        proxy.SETTINGS.update(
            # Приложения Станции заводят пользователи и часто указывают
            # неверный client_id, поэтому для этих приложений считаем отказ
            # InvalidClient равносильным недействительному токену. А для
            # яндексовых приложений продолжаем считать InvalidClient особым
            # случаем.
            treat_invalid_client_as_invalid_token=True,

            # Приложения Станции заводят пользователи и часто их OAuth-серверы
            # не умеют обновлять токены, но пользователи указывают обратное,
            # из-за этого ломается сценарий автоматического обновления токена.
            # Чтобы выходить из такой ситуации с наименьшими потерями, считаем
            # отказы UnsupportedGrantType и UnauthorizedClient равносильными недействительному токену.
            # А для яндексовых приложений продолжаем считать UnsupportedGrantType и
            # UnauthorizedClient особыми случаями.
            treat_unsupported_grant_type_as_invalid_token=True,
            treat_unauthorized_client_as_invalid_token=True,

            # Не обращаем внимание на отказ InvalidClient, т.к. скорее он
            # произойдёт из-за неправильного настроенного Oauth2-сервера
            # партнёра, нежели по нашей вине.
            treat_invalid_request_as_invalid_token=True,
        )
    proxy.r.settings = proxy.SETTINGS
    return proxy


# TODO - statbox
# TODO - mode=simple

# TODO - http://vk.com/pages?oid=-1&p=users.get - counters
# TODO - на подписке нет грантов в ручке создания профиля


def init():
    providers.init()
    from . import (  # noqa
        AppleProxy,
        DeezerProxy,
        DnevnikRuProxy,
        FacebookProxy,
        EsiaProxy,
        GoogleProxy,
        KinopoiskProxy,
        LastFmProxy,
        MailRuProxy,
        MeethueProxy,
        MicrosoftProxy,
        MosRuProxy,
        MtsBelarusProxy,
        MtsProxy,
        OdnoklassnikiProxy,
        TwitterProxy,
        VkontakteProxy,
        XiaomiProxy,
        YahooProxy,
        YandexProxy,
    )


# словарь доступных проксиков
mapper = ApplicationMapper()
