# -*- coding: utf-8 -*-

from passport.backend.social.common import exception as common_exceptions
from passport.backend.social.common.error_handler import ErrorHandler as _ErrorHandler
from passport.backend.social.common.exception import FailureSourceType


class ErrorHandler(_ErrorHandler):
    def _exception_to_error_type(self):
        if (
            isinstance(self._exception, common_exceptions.BasicProxylibError) and
            self._exception.is_normal_workflow_error
        ):
            error_type = FailureSourceType.not_error
        else:
            error_type = super(ErrorHandler, self)._exception_to_error_type()
        return error_type
