# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from . import mapping
from .common import Repo


class FacebookRepo(Repo):
    code = 'fb'

    def parse_response(self):
        self.deserialize_json()
        self.parse_error_response()

    def _replace_userid(self, profile):
        profile['userid'] = str(profile['userid'])

    def _convert_avatar(self, source):
        avatar = source.pop('avatar', None)
        if avatar and not avatar['data']['is_silhouette']:
            source['avatar'] = {
                '0x0': avatar['data']['url'],
            }

    def convert_profile(self, profile):
        self._replace_userid(profile)
        self._convert_avatar(profile)

        friends_count = profile.get('friends', {}).get('summary', {}).get('total_count')
        if friends_count is not None:
            profile['friends_count'] = friends_count

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        self.parse_error_dict(self.context['data'])

    def parse_error_dict(self, _dict):
        if 'error' in _dict:
            error = _dict['error']
            code = error['code']
            message = error['message']
            description = error.get('error_user_msg')
        elif 'error_code' in _dict:
            code = _dict['error_code']
            message = _dict['error_msg']
            description = None
        else:
            return

        self.raise_correct_exception(code, message, description)


mapping[FacebookRepo.code] = FacebookRepo
