# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from lxml.etree import XPathEvalError
from passport.backend.social.common.exception import (
    InvalidTokenProxylibError,
    PermissionProxylibError,
)
from passport.backend.social.common.misc import trim_message

from . import mapping
from .common import Repo


logger = logging.getLogger('proxylib.repo.gg')


class GoogleRepo(Repo):
    code = 'gg'

    def parse_response(self):
        self.deserialize_json()
        self.parse_error_response()

    def convert_profile(self, profile):
        if not self.context['data'].get('email_verified'):
            profile['email'] = None
        if profile['email'] and profile['email'].endswith('@gmail.com'):
            profile['username'] = profile['email'].split('@')[0]
        profile['userid'] = str(profile['userid'])

    def convert_album(self, album):
        try:
            album['photo_count'] = int(album['photo_count'])
        except ValueError:
            pass
        self.parse_datetime(album, 'created')

    def convert_photo(self, photo):
        for key in ['url', 'width', 'height']:
            if key not in photo:
                return True

        photo['images'] = [{
            'url': photo.pop('url'),
            'width': photo.pop('width'),
            'height': photo.pop('height'),
        }]
        return False

    def extract_mails_unread_count(self):
        try:
            r = list(self.context['data'].iter('{http://purl.org/atom/ns#}fullcount'))[0].text
            self.context['processed_data'] = int(r)
        except (ValueError, IndexError) as e:
            logger.warning('Exception during parsing mails_unread_count response: %s', trim_message(e, cut=False))
            self.context['processed_data'] = 0

    @staticmethod
    def get_location(point):
        pos = point.split()
        return {
            'latitude': float(pos[0]),
            'longitude': float(pos[1]),
        }

    def _extract_data(self, item, entry, mapping, ns):
        for path, mapper in mapping.iteritems():
            if isinstance(mapper, dict):
                try:
                    values = entry.xpath(path, namespaces=ns)
                except XPathEvalError:
                    continue

                if not values or not values[0]:
                    continue

                self._extract_data(item, values[0], mapper, ns)
            else:
                dst_name, field_converter = mapper
                logger.info('%s', dst_name)
                try:
                    values = entry.xpath(path, namespaces=ns)
                except XPathEvalError:
                    continue

                if not values:
                    continue

                value = values[0] if isinstance(values[0], basestring) else values[0].text

                if not value:
                    continue

                if field_converter is not None:
                    if isinstance(field_converter, basestring):
                        field_converter = getattr(self, field_converter)
                    value = field_converter(value)
                    if value is None:
                        continue

                item[dst_name] = value

    def extract_xml_entries(self, mapping, converter=None):
        result = []

        ns = self.context['data'].nsmap
        ns['atom'] = ns.pop(None)

        try:
            for entry in self.context['data'].xpath('//atom:entry', namespaces=ns):
                item = {}
                self._extract_data(item, entry, mapping, ns)
                if converter:
                    should_skip = converter(item)
                    if should_skip:
                        continue
                result.append(item)

        except (ValueError, IndexError) as e:
            logger.warning('Exception during parsing response: %s', trim_message(e, cut=False))
            self.context['processed_data'] = None
        self.context['processed_data'] = result

    def parse_error_response(self):
        http_status = self.context['raw_response'].status
        response = self.context['data']
        error_code = None
        error_message = None

        if http_status // 100 in [4, 5]:
            error_code = http_status
            if isinstance(response, dict):
                error_message = response.get('error_description')

        if isinstance(response, dict) and 'error' in response:
            error_dict = response
            if isinstance(error_dict['error'], basestring):
                error_code = error_dict['error']
                error_message = error_dict.get('error_description')
            elif isinstance(error_dict['error'], dict):
                error_dict = error_dict['error']
                error_code = error_dict['code']
                error_message = error_dict.get('message')

        if error_code is not None:
            self.raise_correct_exception(error_code, error_message)

    def parse_error_code_value(self):
        if self.context['raw_response'].status == 401:
            raise InvalidTokenProxylibError('Not authorized')
        elif self.context['raw_response'].status == 403:
            raise PermissionProxylibError(self.context['raw_response'].decoded_data)


mapping[GoogleRepo.code] = GoogleRepo
