# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.proxylib.repo import mapping
from passport.backend.social.proxylib.repo.common import Repo


logger = logging.getLogger('proxylib.repo.lf')


class LastFmRepo(Repo):
    code = 'lf'

    def convert_profile(self, profile):
        name = profile.pop('name', '')
        items = name.strip().split(' ', 1)
        profile['firstname'] = items[0] or None
        profile['lastname'] = items[1] if len(items) == 2 else None

        profile['userid'] = profile['username'] = str(profile['userid'])

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        error_code = self.context['data'].get('error')
        if error_code is None:
            return
        error_message = self.context['data'].get('message')
        self.raise_correct_exception(error_code, error_message)

    def generate_md5_signature(self, params, *args, **kwargs):
        unsignable_keys = {'format'}
        signables = {k: v for k, v in params.iteritems() if k not in unsignable_keys}
        return super(LastFmRepo, self).generate_md5_signature(signables, *args, **kwargs)


mapping[LastFmRepo.code] = LastFmRepo
