# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.common.providers.Microsoft import Microsoft

from . import mapping
from .common import Repo


logger = logging.getLogger('proxylib.repo.%s' % Microsoft.code)


class MicrosoftRepo(Repo):
    code = Microsoft.code

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        error = self.context['data'].get('error')
        if error:
            code = error['code']
            message = error['message']
        else:
            return

        self.raise_correct_exception(code, message)

    def convert_birthday(self, source=None):
        if source is None:
            source = self.context['processed_data']

        day = source.pop('birth_day', None)
        month = source.pop('birth_month', None)
        year = source.pop('birth_year', None)

        if not day or not month:
            source['birthday'] = None
        else:
            source['birthday'] = '%s-%s-%s' % (
                year if year else '0000',
                str(month).zfill(2),
                str(day).zfill(2),
            )

    def convert_avatar(self, avatar_url, source=None):
        if source is None:
            source = self.context['processed_data']
        userid = source['userid']

        source['avatar'] = {
            '96x96': avatar_url % {'userid': userid, 'size': 'small'},
            '180x180': avatar_url % {'userid': userid, 'size': 'medium'},
            '360x360': avatar_url % {'userid': userid, 'size': 'large'},
        }

    def convert_emails(self, source=None):
        if source is None:
            source = self.context['processed_data']

        emails = source.pop('emails', {})
        source['email'] = emails.get('account')
        source['username'] = source['email']


mapping[MicrosoftRepo.code] = MicrosoftRepo
