# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.core.types.phone_number.phone_number import InvalidPhoneNumber
from passport.backend.social.common.exception import UnexpectedResponseProxylibError
from passport.backend.social.common.providers.MtsBelarus import MtsBelarus
from passport.backend.social.proxylib.repo import mapping
from passport.backend.social.proxylib.repo.common import (
    convert_phone_number,
    Repo,
)
from passport.backend.social.proxylib.repo.MtsRepo import convert_userid


logger = logging.getLogger('proxylib.repo.%s' % MtsBelarus.code)


class MtsBelarusRepo(Repo):
    code = MtsBelarus.code

    def parse_error_response(self):
        response = self.context['raw_response']
        if response.status != 200:
            self.raise_correct_exception(response.status, '')

    def convert_profile(self, profile):
        convert_userid(profile)
        try:
            convert_phone_number(profile, 'BY')
        except InvalidPhoneNumber:
            raise UnexpectedResponseProxylibError()
        if not profile.get('phone'):
            raise UnexpectedResponseProxylibError()


mapping[MtsBelarusRepo.code] = MtsBelarusRepo
