# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from . import mapping
from .common import Repo


logger = logging.getLogger('proxylib.repo.ok')


class OdnoklassnikiRepo(Repo):
    code = 'ok'
    photo_sizes = {
        'pic50x50': (50, 50),
        'pic128x128': (128, 128),
        'pic190x190': (190, 190),
        'pic640x480': (640, 480),
        'pic1024x768': (1024, 768),
    }

    def parse_response(self):
        self.deserialize_json()
        self.parse_error_response()

    def convert_profile(self, profile):
        profile['userid'] = str(profile['userid'])

    def convert_album(self, album):
        self.parse_datetime(album, 'created')

    def convert_photo(self, photo):
        width = photo.pop('width')
        height = photo.pop('height')
        images = []
        for key, sizes in self.photo_sizes.iteritems():
            photo_width = min(sizes[0], width)
            photo_height = min(sizes[1], height)
            url = photo.pop(key, None)
            if not url:
                continue
            images.append(dict(url=url, width=photo_width, height=photo_height))
        photo['images'] = sorted(images, key=lambda x: x['width']*x['height'])

    def convert_group(self, group):
        group['gid'] = str(group['gid'])
        private = group.pop('private', None)
        if isinstance(private, bool):
            group['privacy'] = 'private' if private else 'public'

    def convert_photo_albums_privacy(self, mapping):
        for album in self.context['processed_data']:
            types = [x.lower() for x in album.pop('types', [])]
            type_ = album.pop('type', None)
            if type_:
                album['visibility'] = mapping.get(type_.lower())
            elif types:
                friend_privs = [x for x in types if x in ['friends', 'colleague', 'classmate', 'cursemate']]
                album['visibility'] = 'friends' if friend_privs else 'private'

    def extract_events_count(self, event_type):
        events = [x for x in self.context['data'] if x['type'] == event_type]
        if not events:
            self.context['processed_data'] = 0
            return

        self.context['processed_data'] = events[0]['number']

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        error_code = self.context['data'].get('error_code')
        if error_code is None:
            return
        error_message = self.context['data'].get('error_msg')
        self.raise_correct_exception(error_code, error_message)

    def detect_album_not_exists_error(self, error_code, error_message):
        # формат ответа при ошибке:
        # {"error_code":120,"error_data":null,"error_msg":"PARAM_ALBUM_ID : Param [vsdg] conversion failed."}
        return 'PARAM_ALBUM_ID' in error_message


mapping[OdnoklassnikiRepo.code] = OdnoklassnikiRepo
