# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.common.oauth1 import Oauth1RequestSigner
from passport.backend.social.proxylib.repo import mapping
from passport.backend.social.proxylib.repo.common import Repo


logger = logging.getLogger('proxylib.repo.tw')


class TwitterRepo(Repo):
    code = 'tw'

    profile_links = [
        'http://twitter.com/%(username)s/',
    ]

    def parse_response(self):
        self.deserialize_json()
        self.parse_error_response()

    def convert_profile(self, profile):
        profile['userid'] = str(profile['userid'])
        display_name = profile.pop('name', None)
        if display_name:
            profile['firstname'], profile['lastname'] = self.parse_display_name(display_name)

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        errors = self.context['data'].get('errors')
        if errors is None:
            error = self.context['data'].get('error')
            if error is None:
                return
            errors = [{'code': None, 'message': error}]
        self.raise_correct_exception(errors[0]['code'], errors[0]['message'])

    def get_request_signer(self):
        return Oauth1RequestSigner(
            client_id=self.app.id,
            client_secret=self.app.secret,
            oauth_token=self.access_token['value'],
            oauth_token_secret=self.access_token['secret'],
        )

mapping[TwitterRepo.code] = TwitterRepo
