# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging
import os
from os import path

from passport.backend.social.proxylib.repo import mapping
from passport.backend.social.proxylib.repo.common import Repo
from passport.backend.utils.file import (
    path_exists,
    read_file,
)


logger = logging.getLogger('proxylib.repo.vk')

DATA_DIR = path.normpath(
    path.join(
        path.dirname(__file__),
        os.pardir,
        'data',
    ),
)
LOCATION_CITIES_PATH = path.join(DATA_DIR, 'vk_cities_to_geobase.json')
LOCATION_COUNTRIES_PATH = path.join(DATA_DIR, 'vk_countries_to_geobase.json')


if not path_exists(LOCATION_CITIES_PATH):
    raise Exception('Can not load "%s": does not exist' % LOCATION_CITIES_PATH)  # pragma: no cover
try:
    logger.debug(LOCATION_CITIES_PATH)
    locations_cities_base = json.loads(read_file(LOCATION_CITIES_PATH))
    logger.debug(LOCATION_COUNTRIES_PATH)
    locations_countries_base = json.loads(read_file(LOCATION_COUNTRIES_PATH))
except Exception as ex:  # pragma: no cover
    raise Exception('Can not load VK bases: %s' % str(ex))


get_powers_of_two = lambda n: [int(x) * 2**i for i, x in enumerate(reversed(bin(n)[2:]))]


class VkontakteRepo(Repo):
    code = 'vk'

    def parse_response(self):
        self.deserialize_json()
        self.parse_error_response()

    def convert_profile(self, profile):
        if profile.get('userid'):
            profile['userid'] = str(profile['userid'])

        domain = profile.pop('domain', None)
        userid = profile.get('userid')
        if domain and userid and domain != 'id' + userid:
            profile['username'] = domain

        mobile_phone = profile.pop('mobile_phone', None)
        home_phone = profile.pop('home_phone', None)
        phone = mobile_phone or home_phone
        if phone:
            profile['phone'] = phone

    def extract_location(self, source=None):
        if source is None:
            source = self.context['processed_data']
        city = source.pop('city', None)
        country = source.pop('country', None)

        if country is None or city is None:
            return

        city = locations_cities_base.get(str(city['id']))
        country = locations_countries_base.get(str(country['id']))

        if city:
            source['city_id'] = city.get('geobase_id')
            source['city_name'] = city.get('name') or city.get('title')
        if country:
            source['country_id'] = country.get('geobase_id')
            source['country_code'] = country.get('code')

    def extract_friends_location(self):
        for user in self.context['processed_data']:
            self.extract_location(source=user)

    def parse_error_response(self):
        if not isinstance(self.context['data'], dict):
            return
        error = self.context['data'].get('error')
        if error is None:
            return
        self.raise_correct_exception(error['error_code'], error['error_msg'])

    def get_token_scopes(self, mapping):
        permissions_int = self.context['data']['response']
        powers_of_two = get_powers_of_two(permissions_int)
        scopes = [mapping[p] for p in powers_of_two if p in mapping]
        self.context['processed_data']['scopes'] = scopes


mapping[VkontakteRepo.code] = VkontakteRepo
