# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.providers.Yahoo import Yahoo

from . import mapping
from .common import Repo


class YahooRepo(Repo):
    code = Yahoo.code

    def compose_request(self, additional_args=None, **kwargs):
        if additional_args is None:
            additional_args = {}
        additional_args.update({'format': 'json'})
        super(YahooRepo, self).compose_request(additional_args=additional_args, **kwargs)

    def parse_http_error_response(self):
        http_status = self.context['raw_response'].status
        if http_status == 401:
            self.raise_correct_exception(http_status, '')

    def parse_error_response(self):
        response = self.context['data']
        if 'error' in response:
            self.raise_correct_exception(None, response['error']['description'])


mapping[YahooRepo.code] = YahooRepo
