# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.providers.Yandex import Yandex

from . import mapping
from .common import Repo


class YandexRepo(Repo):
    code = Yandex.code

    def parse_error_response(self):
        response = self.context['raw_response']
        if response.status != 200:
            self.raise_correct_exception(response.status, '')

    def parse_response(self):
        self.parse_error_response()
        self.deserialize_json()


mapping[YandexRepo.code] = YandexRepo
