# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.exception import InternalProxylibError


def get_repo(code):
    if code not in mapping:
        raise InternalProxylibError('Repo for provider %s not found' % code)
    return mapping[code](code)


def init():
    from . import (  # noqa
        AppleRepo,
        DeezerRepo,
        DnevnikRuRepo,
        EsiaRepo,
        FacebookRepo,
        GoogleRepo,
        KinopoiskRepo,
        LastFmRepo,
        MailRuRepo,
        MeethueRepo,
        MicrosoftRepo,
        MosRuRepo,
        MtsBelarusRepo,
        MtsRepo,
        OdnoklassnikiRepo,
        TwitterRepo,
        VkontakteRepo,
        XiaomiRepo,
        YahooRepo,
        YandexRepo,
    )


mapping = dict()  # словарь доступных repo's
init()
