# -*- coding: utf-8 -*-

import logging

from passport.backend.social.common.exception import (
    NetworkProxylibError,
    ProviderTemporaryUnavailableProxylibError,
)
from passport.backend.social.common.useragent import (
    get_http_pool_manager,
    get_zora_useragent,
    RequestError as RequestUseragentError,
    ServiceTemporaryUnavailableUseragentError,
    UserAgent,
)


logger = logging.getLogger(__name__)


def execute_request(from_intranet=True, **kwargs):
    if from_intranet:
        useragent = UserAgent(pool_manager=get_http_pool_manager())
    else:
        useragent = get_zora_useragent()

    try:
        response = useragent.request(**kwargs)
    except RequestUseragentError as e:
        raise NetworkProxylibError(unicode(e))
    except ServiceTemporaryUnavailableUseragentError as e:
        new_e = ProviderTemporaryUnavailableProxylibError(unicode(e))
        new_e.service_temporary_unavailable_exception = e.service_temporary_unavailable_exception
        raise new_e

    return response
