# -*- coding: utf-8 -*-

import datetime
from random import SystemRandom

from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.social.common.db.utils import (
    build_master_db_config,
    build_slave_db_config,
    create_engine,
)
from passport.backend.social.common.limits import QLimits
from passport.backend.social.common.provider_settings import providers
import passport.backend.social.common.redis_client as redis_client
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.useragent import (
    build_http_pool_manager,
    OfflineZoraUseragent,
)
import passport.backend.social.proxylib


def init():
    social_config.init()

    LazyLoader.register('chrono', lambda: datetime.datetime)
    LazyLoader.get_instance('chrono')

    LazyLoader.register('randomizer', SystemRandom)
    LazyLoader.get_instance('randomizer')

    LazyLoader.register('qlimits', QLimits)
    LazyLoader.get_instance('qlimits')

    LazyLoader.register('http_pool_manager', build_http_pool_manager)
    LazyLoader.get_instance('http_pool_manager')

    read_engine = create_engine(build_slave_db_config(social_config), False)
    LazyLoader.register('slave_db_engine', lambda: read_engine)
    LazyLoader.get_instance('slave_db_engine')

    write_engine = create_engine(build_master_db_config(social_config), False)
    LazyLoader.register('master_db_engine', lambda: write_engine)
    LazyLoader.get_instance('master_db_engine')

    redis_client.RedisClient.init()
    LazyLoader.register('redis', redis_client.RedisClient)
    LazyLoader.get_instance('redis')

    LazyLoader.register('zora_useragent', OfflineZoraUseragent)
    LazyLoader.get_instance('zora_useragent')

    providers.init()
    passport.backend.social.proxylib.init()
