# -*- coding: utf-8 -*-

import os
from os import path
import sys

from passport.backend.social.common.context import request_ctx
from passport.backend.social.common.social_logging import (
    ExceptionFormatter,
    SocialFormatter,
    WarningFormatter,
)


if os.environ.get('SYSTEM_WIDE_SOCIAL_UTILS'):
    LOG_PATH = '/var/log/yandex/socialism'
else:
    LOG_PATH = '.'

root_handlers = {
    'social_utils',
    'passport.backend.social.utils.error',
    'passport.backend.social.utils.exception',
    'passport.backend.social.utils.warning',
}
if not os.environ.get('SYSTEM_WIDE_SOCIAL_BROKER'):
    root_handlers.add('console')

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': SocialFormatter,
            'context': request_ctx,
        },
        'exception': {
            '()': ExceptionFormatter,
            'context': request_ctx,
            'logtype': 'social-utils-exception-log',
        },
        'warning': {
            '()': WarningFormatter,
            'context': request_ctx,
            'logtype': 'social-utils-warning-log',
        },
        'simple': {
            'format': "%(message)s"
        },
    },
    'root': {
        'handlers': root_handlers,
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'default',
            'stream': sys.stdout,
        },
        'social_utils': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-utils.debug.log'),
            'formatter': 'default',
            'level': 'DEBUG',
        },
        'passport.backend.social.utils.error': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': path.join(LOG_PATH, 'social-utils.error.log'),
            'formatter': 'default',
            'level': 'ERROR',
        },
        'passport.backend.social.utils.exception': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-utils.exception.log'),
            'formatter': 'exception',
            'level': 'ERROR',
            'filters': ['exception_filter'],
        },
        'passport.backend.social.utils.warning': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-utils.warning.log'),
            'formatter': 'warning',
            'filters': ['warning_filter'],
        },
        'graphite': {
            'class': 'passport.backend.social.common.social_logging.OsFileHandler',
            'filename': os.path.join(LOG_PATH, 'social-utils.graphite.log'),
            'formatter': 'simple',
        },
    },
    'filters': {
        'exception_filter': {
            '()': 'passport.backend.social.common.social_logging.ExceptionFilter',
        },
        'warning_filter': {
            '()': 'passport.backend.social.common.social_logging.LevelFilter',
            'levels': ['WARNING'],
        },
    },
    'loggers': {
        'graphite.database': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'graphite.useragent': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'graphite.redis': {
            'handlers': ['graphite'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'urllib3': {
            'level': 'INFO',
        },
        'passport.backend.social.common._urllib3': {'level': 'WARNING'},
        'passport.backend.social.common.db.execute': {'level': 'WARNING'},
        'passport.backend.social.common.useragent': {'level': 'INFO'},
    },
}
