# -*- coding: utf-8 -*-

import sys

from celery.bin.celery import CeleryCommand
from passport.backend.social.common.importer import (
    install_file_system_importer,
    install_python_path2,
)


def main():
    # Celery multi не умеет запускаться не из python, поэтому здесь
    # притворяемся, что мы Python.
    if sys.argv[1:3] == ['-m', 'celery']:
        sys.argv[:] = [sys.argv[0]] + sys.argv[3:]

    install_python_path2()
    install_file_system_importer()

    cmd = CeleryCommand()
    cmd.maybe_patch_concurrency()

    from billiard import freeze_support
    freeze_support()
    sys.exit(cmd.execute_from_commandline(sys.argv))


if __name__ == '__main__':
    main()
