# -*- coding: utf-8 -*-
import logging

from flask import (
    Blueprint,
    Flask,
)
from passport.backend.core.grants import get_grants_config
from passport.backend.takeout.api import (
    env,
    logs,
    views,
)
from passport.backend.takeout.common.conf import configure_settings
from passport.backend.utils.warnings import enable_strict_bytes_mode


log = logging.getLogger('takeout.api')


def create_app():
    enable_strict_bytes_mode()

    name = 'takeout_api'
    app = Flask(
        name,
        static_folder=None,
    )

    api_1 = Blueprint('api', name)
    api_1.add_url_rule(
        '/prepare_archive/',
        view_func=views.prepare_archive.prepare_archive,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/upload/',
        view_func=views.upload_proxy.upload,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/upload/done/',
        view_func=views.upload_proxy.upload_done,
        methods=['POST'],
    )

    # Ручки для отладки
    api_1.add_url_rule(
        '/debug/job_id/',
        view_func=views.upload_proxy.get_debug_job_id,
        methods=['GET'],
    )
    api_1.add_url_rule(
        '/debug/async_start/',
        view_func=views.upload_proxy.debug_start_process,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/debug/run_integration_test/',
        view_func=views.debug_integration.run_integration_test,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/debug/get_status/',
        view_func=views.get_status.get_status,
        methods=['GET', 'POST'],
    )

    # Ручки, имитирующие сторонние сервисы
    api_1.add_url_rule(
        '/test/fake_services/get_file/',
        view_func=views.fake_services.fake_get_file,
        methods=['GET'],
    )
    api_1.add_url_rule(
        '/test/fake_services/sync/user_info/',
        view_func=views.fake_services.fake_user_info,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/test/fake_services/async/start/',
        view_func=views.fake_services.fake_async_start,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/test/fake_services/async/user_info/',
        view_func=views.fake_services.fake_user_info,
        methods=['POST'],
    )
    api_1.add_url_rule(
        '/test/fake_services/async_upload/start/',
        view_func=views.fake_services.fake_async_upload_start,
        methods=['POST'],
    )

    app.register_blueprint(api_1, url_prefix='/1')

    app.add_url_rule(
        '/ping',
        view_func=views.ping.ping,
        methods=['GET', 'POST'],
    )

    # конфигурируем сеттинги
    configure_settings()

    # подгружаем конфиги для грантов
    get_grants_config()

    app.before_request(env.prepare_env)
    app.before_request(logs.setup_log_prefix)
    app.before_request(logs.log_request)

    app.after_request(logs.log_response)

    return app
