# -*- coding: utf-8 -*-

from flask import jsonify
import passport.backend.core.s3 as s3_exceptions
import passport.backend.takeout.logbroker_client.exception_handler as lbc_exceptions
import yenv


def ok_response(status='ok', **kwargs):
    return json_response(200, status=status, **kwargs)


def json_response(status_code=200, **kwargs):
    rv = jsonify(**kwargs)
    rv.status_code = status_code
    return rv


def render_form_error(form):
    sorted_errors = sorted(form.errors.items(), key=lambda field_errors: field_errors[0])
    error_txt = ['{}: {}'.format(field, ', '.join(errors)) for field, errors in sorted_errors]
    error = '; '.join(error_txt)

    return json_response(
        400,
        status='error',
        error=error,
        env=yenv.type,
    )


def exception_to_response(exception):
    args = dict(
        description=u'{}: {}'.format(exception.__class__.__name__, str(exception)),
        env=yenv.type,
        status='error',
    )
    try:
        raise exception
    except s3_exceptions.BaseS3Error:
        args.update(error='s3.unavailable')
    except lbc_exceptions.LogbrokerWriterError:
        args.update(
            description='Logbroker unavailable',
            error='internal.temporary_error',
            status_code=503,
        )
    except Exception:
        args.update(
            description='Unhandled exception',
            error='internal.permanent_error',
            status_code=500,
        )

    return json_response(**args)
