# -*- coding: utf-8 -*-
from collections import namedtuple
import random
import string

from flask import request


REQUEST_ID_ALPHABET = string.digits + string.ascii_letters
# в nginx request_id это 32 символа
REQUEST_ID_LENGTH = 32

APIEnvironment = namedtuple('APIEnvironment', ['consumer_ip', 'service_ticket', 'request_id'])


def _generate_request_id(length):
    # g - generated, чтобы было сразу понятно, что request id не прилетел снаружи
    prefix = 'g-'
    return prefix + ''.join(random.choice(REQUEST_ID_ALPHABET) for _ in range(length - len(prefix)))


def prepare_env():
    consumer_ip = request.environ.get(
        'HTTP_X_REAL_IP',
        request.environ['REMOTE_ADDR'],
    )

    request_id = request.environ.get('HTTP_X_REQUEST_ID')
    if not request_id:
        request_id = _generate_request_id(REQUEST_ID_LENGTH)

    request.env = APIEnvironment(
        service_ticket=request.environ.get('HTTP_X_YA_SERVICE_TICKET', None),
        consumer_ip=consumer_ip,
        request_id=request_id,
    )
