# -*- coding: utf-8 -*-
from io import BytesIO
from urllib.parse import urljoin

from flask import (
    request,
    Response,
    url_for,
)
from passport.backend.takeout.api.base import ok_response
from passport.backend.takeout.api.decorators import validate
from passport.backend.takeout.api.views.forms import (
    FakeServiceAsyncUploadStartForm,
    FakeServiceFileForm,
)
from passport.backend.takeout.common.job_id import parse_job_id
from passport.backend.takeout.common.touch import TouchFiles
from passport.backend.takeout.common.utils import encrypt_and_upload_to_s3


def fake_user_info():
    return ok_response(
        data={
            '1.txt': 'Content 1',
            '2.txt': 'Content 2',
        },
        file_links=[
            urljoin(request.url_root, url_for('api.fake_get_file', file_name='3.txt')),
            urljoin(request.url_root, url_for('api.fake_get_file', file_name='4.txt')),
        ],
    )


@validate(FakeServiceFileForm)
def fake_get_file(args):
    file_name = args['file_name']

    return Response(
        response='%s content' % file_name,
        status=200,
        headers={
            'Content-Disposition': 'attachment; filename="%s"' % file_name,
        },
    )


def fake_async_start():
    return ok_response(
        job_id='job-id',
    )


@validate(FakeServiceAsyncUploadStartForm)
def fake_async_upload_start(args):
    job_id = parse_job_id(args['job_id'])

    encrypt_and_upload_to_s3(
        uid=job_id.uid,
        extract_id=job_id.extract_id,
        service_name=job_id.service_name,
        file_name='5.txt',
        file_object=BytesIO(b'Content 5'),
    )

    touch = TouchFiles.from_job_id(job_id)
    touch.set(TouchFiles.AsyncUpload.DONE)

    return ok_response()
