# -*- coding: utf-8 -*-
from passport.backend.core.logging_utils.request_id import RequestIdManager
from passport.backend.takeout.api.base import ok_response
from passport.backend.takeout.api.decorators import (
    grants,
    statbox_oneline_logger,
    validate,
)
from passport.backend.takeout.api.grants import GRANT_DEBUG_GET_STATUS
from passport.backend.takeout.api.views.forms import DebugGetStatusForm
from passport.backend.takeout.common.conf.services import get_service_configs
from passport.backend.takeout.common.touch import TouchFiles


STATUS_NOT_STARTED = 'not_started'
STATUS_STARTED = 'started'
STATUS_ORDERED_DATA = 'ordered_data'
STATUS_DONE = 'done'


@validate(DebugGetStatusForm)
@statbox_oneline_logger(
    base_params={
        'action': 'debug_get_status',
    },
)
@grants([GRANT_DEBUG_GET_STATUS])
def get_status(args, statbox):
    uid = args['uid']
    extract_id = args['extract_id']
    selected_service_names = set(args.get('service_name', []))

    # Добавление в логи информации об extract_id и обо всех указанных в запросе service_name
    RequestIdManager.push_request_id(extract_id, *selected_service_names)

    service_configs = get_service_configs()

    service_statuses = {}
    for service_name, service_config in service_configs.items():
        if selected_service_names and service_name not in selected_service_names:
            continue

        touch = TouchFiles(uid, extract_id, service_name)
        if service_config.type == 'sync':
            if touch.is_set(TouchFiles.Sync.DONE):
                status = STATUS_DONE
            elif touch.is_set(TouchFiles.Sync.STARTED):
                status = STATUS_STARTED
            else:
                status = STATUS_NOT_STARTED
        elif service_config.type == 'async':
            if touch.is_set(TouchFiles.AsyncPoll.DONE):
                status = STATUS_DONE
            elif touch.is_set(TouchFiles.AsyncPoll.STARTED):
                status = STATUS_STARTED
            else:
                status = STATUS_NOT_STARTED
        elif service_config.type == 'async_upload':
            if touch.is_set(TouchFiles.AsyncUpload.DONE):
                status = STATUS_DONE
            elif touch.is_set(TouchFiles.AsyncUpload.ORDERED_DATA):
                status = STATUS_ORDERED_DATA
            elif touch.is_set(TouchFiles.AsyncUpload.STARTED):
                status = STATUS_STARTED
            else:
                status = STATUS_NOT_STARTED
        else:
            raise NotImplementedError('Unknown service type: `%s`' % service_config.type)  # noqa

        service_statuses[service_name] = {'status': status}

    statbox.bind(
        status='ok',
    )

    # TODO: добавить статусы прочих тасок (стартовой, завершающей?)
    return ok_response(
        services=service_statuses,
    )
