# -*- coding: utf-8 -*-
import os

from flask import (
    jsonify,
    Response,
)
from passport.backend.takeout.api.decorators import validate
from passport.backend.takeout.api.views.forms import PingForm
from passport.backend.takeout.common.conf import get_config
from passport.backend.takeout.common.redis import get_redis
from redis import ConnectionError
from redis.sentinel import MasterNotFoundError


def error_response(status=521, **kwargs):
    response = jsonify(**kwargs)
    response.status_code = status
    return response


@validate(PingForm)
def ping(args):
    check = [
        value.strip().lower()
        for value in args['check'].split(',')
        if value.strip()
    ]
    config = get_config()

    # Проверяем доступность файла. Если его нет или он недоступен - значит, мы должны закрыться от балансера
    if not os.access(config['common']['ping_file'], os.R_OK):
        return error_response(error='service.shut_down')

    if 'db' in check:
        try:
            client = get_redis()
            client.ping()
        except (ConnectionError, MasterNotFoundError) as error:
            return error_response(error='redis.unavailable', description=str(error))

    return Response(response='Pong\n', status=200)
