# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.request_id import RequestIdManager
from passport.backend.takeout.api.base import ok_response
from passport.backend.takeout.api.decorators import (
    grants,
    statbox_oneline_logger,
    validate,
)
from passport.backend.takeout.api.grants import GRANT_PREPARE_ARCHIVE
from passport.backend.takeout.api.views.forms import PrepareArchiveForm
from passport.backend.takeout.common.utils import (
    get_extract_id,
    get_task_id,
)
from passport.backend.takeout.logbroker_client.download_user_data import send_extract_task_message


@validate(PrepareArchiveForm)
@statbox_oneline_logger(
    base_params={
        'action': 'prepare_archive',
    },
    exclude_form_fields=['unixtime'],
)
@grants([GRANT_PREPARE_ARCHIVE])
def prepare_archive(args, statbox):
    uid = args['uid']
    unixtime = args['unixtime']

    extract_id = get_extract_id()

    statbox.bind(
        extract_id=extract_id,
        archive_requested_unixtime=unixtime,
    )

    # Добавление в логи информации о текущем extract_id
    RequestIdManager.push_request_id(extract_id)

    send_extract_task_message(
        extract_id=extract_id,
        manual_takeout=args.get('manual_takeout'),
        task_id=get_task_id(),
        uid=uid,
        unixtime=unixtime,
        source='takeout_api',
    )

    statbox.bind(
        status='ok',
    )

    return ok_response(
        extract_id=extract_id,
    )
