# -*- coding: utf-8 -*-
import os
import os.path

from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.library.configurator import Configurator
import yenv


CONFIG_DIR = '/usr/lib/yandex/passport-takeout/settings/'
LOCAL_CONFIG_DIR = os.path.expanduser('~/.arcadia_settings/takeout/')

UNDER_TESTS = os.environ.get('YA_MAKE_T')


def _get_config_list(prefix=''):
    # Порядок конфигов важен: каждый следующий конфиг может ссылаться на настройки из предыдущих.
    # По кастомному пути берутся только секреты и overridden_settings (настройки, которые админы могут
    # прописать руками), остальное приезжает из ресурсов.
    return [
        os.path.join(prefix, 'secrets.yaml?'),
        'settings-common.yaml',
        'settings-%s.yaml' % yenv.type,
        'services-%s.yaml' % yenv.type,
        os.path.join(prefix, 'settings-overridden.yaml?'),
        'passport-settings.yaml',
    ]


LazyLoader.register(
    'config',
    Configurator,
    name='takeout',
    configs=_get_config_list(prefix=CONFIG_DIR),
)


LazyLoader.register(
    'config_laptop',
    Configurator,
    name='takeout',
    configs=_get_config_list(prefix=LOCAL_CONFIG_DIR),
)


LazyLoader.register(
    'config_default',
    Configurator,
    name='takeout',
    configs=_get_config_list(),
)


def get_config():
    default_config = LazyLoader.get_instance('config_default')
    if UNDER_TESTS:
        return default_config
    elif yenv.type == 'development':
        # Это может быть запуск на ноутбуке, на дев-машине или в импорт-тестах аркадии.
        # Соответственно, пробуем несколько вариантов расположения конфигов
        r = LazyLoader.get_instance('config_laptop')
        if r.has_missed_configs():
            r = LazyLoader.get_instance('config')
        if r.has_missed_configs():
            r = default_config

        return r
    else:
        return LazyLoader.get_instance('config') or default_config


def configure_settings():
    config = get_config()
    config.set_logging()
    config.set_as_passport_settings(basename_to_export='passport-settings.yaml')
