# -*- coding: utf-8 -*-

def order_db_hosts_by_dc(db_hosts, current_dc):
    wanted_prefix = current_dc + '-'
    # стабильная сортировка хостов для dbaas
    # если хосты начинаются с wanted_prefix, то они вылезают вперёд
    return sorted(db_hosts, key=lambda h: int(not h.startswith(wanted_prefix)))


def get_redis_settings(conf):
    return {
        'password': conf['redis'].get('db_password', None),
        'sentinel': [(x.split(':', 1)[0], x.split(':', 1)[-1]) for x in conf['redis']['hosts']],
        'socket_connect_timeout': conf['redis'].get('broker_transport_options', {}).get('socket_connect_timeout', None),
        'socket_timeout': conf['redis'].get('broker_transport_options', {}).get('socket_timeout', None),
        'master_name': conf['redis'].get('broker_transport_options', {}).get('master_name', None),
    }
