# -*- coding: utf-8 -*-
from collections import namedtuple

from passport.backend.takeout.common.conf import get_config


class ServiceConfig(namedtuple('ServiceConfig', 'enabled type tvm_dst_alias url_base url_suffix_start url_suffix_get timeout retries run_integration_test_consumers')):
    @classmethod
    def from_dict(cls, dct):
        """
        :param dct: словарь с полями:
          * type - должен соответствовать типу используемого билдера
          * tvm_dst_alias - алиас сервиса в конфиге tvm-keyring
          * urls - словарь с полями:
            * base - общая часть урла для всех ручек
            * suffix_start - суффикс урла стартовой ручки (может отсутствовать, в зависимости от type)
            * suffix_get - суффикс урла ручки получения данных (может отсутствовать, в зависимости от type)
            * timeout (может отсутствовать, тогда будет использоваться дефолтное значение)
            * retries (может отсутствовать, тогда будет использоваться дефолтное значение)
        """
        return cls(
            enabled=dct.get('enabled', False),
            type=dct['type'],
            tvm_dst_alias=dct['tvm_dst_alias'],
            url_base=dct['urls']['base'],
            url_suffix_start=dct['urls'].get('suffix_start'),
            url_suffix_get=dct['urls'].get('suffix_get'),
            timeout=dct.get('timeout'),
            retries=dct.get('retries'),
            run_integration_test_consumers=dct.get('run_integration_test_consumers', []),
        )


def get_service_configs(conf=None, services=None):
    conf = conf or get_config()

    conf_services = conf['services'].items()

    if services:
        return {
            service_name: ServiceConfig.from_dict(service_dict)
            for service_name, service_dict in conf_services if service_name in services
        }

    return {
        service_name: ServiceConfig.from_dict(service_dict)
        for service_name, service_dict in conf_services
    }
