# -*- coding: utf-8 -*-
from passport.backend.takeout.common.conf import get_config


def get_keys_for_signing(conf=None):
    conf = conf or get_config()
    signature_key_prefix = 'DB_SIGNATURE_KEY_'
    keys = {}
    for key, value in conf.items():
        if key.startswith(signature_key_prefix):
            # берём как ключ всё содержимое строки, после префикса
            keys[key[len(signature_key_prefix):]] = value.encode('utf-8')
    return keys


def get_key_version():
    conf = get_config()
    key_version = str(conf['db_key_version_for_signature'])
    return key_version
