# -*- coding: utf-8 -*-


class BaseTakeoutError(Exception):
    pass


class BadSignature(BaseTakeoutError):
    pass


class SignatureMismatch(BadSignature):
    pass


class MalformedSignature(BadSignature):
    pass


class MissingKeyByVersion(BadSignature):
    pass


class BadJobId(BaseTakeoutError):
    pass


class UnsupportedJobIdVersion(BadJobId):
    pass


class MalformedJobId(BadJobId):
    pass


class BaseServiceError(BaseTakeoutError):
    """Базовая ошибка при походе в сторонний сервис за данными"""


class ServiceTemporaryError(BaseServiceError):
    """Временная ошибка при походе в сторонний сервис за данными: нужно поретраиться"""


class ServicePermanentError(BaseServiceError):
    """Нештатная ошибка при походе в сторонний сервис за данными: всё равно нужно ретраиться, но не так часто"""


class ResponseNotReadyError(BaseServiceError):
    """Cторонний сервис ответил, что ответ не готов: нужно поретраиться"""
    def __init__(self, description, *args):
        super(ResponseNotReadyError, self).__init__(description, *args)


class RetryLater(Exception):
    """Исполнение таска нужно отложить на недалёкое будущее"""
