# -*- coding: utf-8 -*-
from passport.backend.core.logbroker.logbroker import LogbrokerWriterProto
from passport.backend.core.logging_utils.request_id import get_request_id


class TakeoutLogbrokerWriterProto(LogbrokerWriterProto):

    def _update_header(self, header):
        request_id = get_request_id()
        if request_id:
            header.takeout.request_id_string = request_id


def get_takeout_logbroker_writer(name, override_host=None, partition_group=None):
    # type: (str, str, int) -> TakeoutLogbrokerWriterProto
    return TakeoutLogbrokerWriterProto(
        name, override_host=override_host, partition_group=partition_group,
    )
