# -*- coding: utf-8 -*-
from contextlib import contextmanager

from passport.backend.core.logging_utils.helpers import trim_message


@contextmanager
def exception_to_statbox(statbox_logger):
    try:
        yield
    except Exception as e:
        statbox_logger.log(
            status='error',
            error=e.__class__.__name__,
            error_message=trim_message(str(e)),
        )
        raise
