# -*- coding: utf-8 -*-
import argparse
import os
import sys

from passport.backend.takeout.common.conf import (
    configure_settings,
    get_config,
)
from passport.backend.takeout.common.conf.crypto import get_keys_for_encrypting
from passport.backend.takeout.common.crypto import (
    decrypt_stream,
    encrypt_stream,
)
from passport.backend.takeout.common.utils import (
    filename_and_key_version_to_s3_key,
    READ_BUFFER_SIZE,
)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-e', '--encrypt', action='store_true', default=False, required=False, help='Encrypt file')
    parser.add_argument('-d', '--decrypt', action='store_true', default=False, required=False, help='Decrypt file')
    parser.add_argument('-b', '--buffer-size', type=int, required=False, default=READ_BUFFER_SIZE, help='Buffer size')
    parser.add_argument('file')
    args = parser.parse_args()
    return args


def run_app():
    configure_settings()
    args = parse_args()
    if args.encrypt and args.decrypt:
        sys.stderr('Pick either encrypt or decrypt\n')
        sys.exit(1)

    keys = get_keys_for_encrypting()
    key_version = get_config()['s3']['encryption_key_version']

    if args.encrypt:
        with open(args.file, 'r') as f_in:
            output_file = encrypt_stream(
                f_in,
                keys,
                key_version,
            )
            with open(filename_and_key_version_to_s3_key(args.file, key_version), 'w') as f_out:
                while True:
                    data = output_file.read(args.buffer_size)
                    if data:
                        f_out.write(data)
                    else:
                        break
    elif args.decrypt:
        with open(args.file, 'r') as f_in:
            file_size = os.stat(args.file).st_size
            output_file = decrypt_stream(
                f_in,
                keys,
                key_version,
                file_size,
            )
            with open('.'.join(args.file.split('.')[:-1]), 'w') as f_out:
                while True:
                    data = output_file.read(args.buffer_size)
                    if data:
                        f_out.write(data)
                    else:
                        break
