# -*- coding: utf-8 -*-
import argparse

from passport.backend.takeout.common.conf import get_config
from passport.backend.takeout.common.conf.services import get_service_configs


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('uid', type=int)

    args = parser.parse_args()
    return args


def mk_url(address, port, service_name, uid):
    url = 'http://{address}:{port}/1/debug/run_integration_test/?consumer=dev'.format(
        address=address,
        port=port,
    )
    return url


def run_app():
    args = parse_args()

    get_config()

    address = get_config()['application']['address']
    port = get_config()['application']['port']

    services = get_service_configs()
    for service_name, service_cfg in services.items():
        if not service_cfg.enabled:
            continue
        print('curl -X POST \'{url}\' -d uid={uid} -d service_name={service_name}'.format(
            url=mk_url(address, port, service_name, args.uid),
            uid=args.uid,
            service_name=service_name,
        ))
