# -*- coding: utf-8 -*-
import os
import os.path

from library.python.vault_client.instances import Production as Vault
from passport.backend.takeout.common.conf import LOCAL_CONFIG_DIR
from passport.backend.takeout.dev_scripts.init.helpers import str_dict
import yaml


SECRETS = 'sec-01cyy1zys2f6yrwwwydstyacyp'


def init_settings():
    local_conf_dir = os.path.expanduser(LOCAL_CONFIG_DIR)
    if not os.path.exists(local_conf_dir):
        os.makedirs(local_conf_dir, mode=0o700)

    # Создадим файл, в который можно будет руками дописать настройки
    custom_settings_filename = os.path.join(LOCAL_CONFIG_DIR, 'settings-overridden.yaml')
    if not os.path.exists(custom_settings_filename):
        with open(custom_settings_filename, 'w'):
            pass
    else:
        print('%s already exists: not overwriting' % custom_settings_filename)

    # Создадим файл с секретами из Секретницы
    secret = Vault().get_version(SECRETS)
    with open(os.path.join(LOCAL_CONFIG_DIR, 'secrets.yaml'), 'w') as f:
        yaml.dump(
            # str_dict, чтобы ключи не имели префиксы !!python/unicode и легче читались глазами
            str_dict(secret['value']),
            f,
            default_flow_style=False,
        )


def run_app():
    init_settings()
