# -*- coding: utf-8 -*-
import argparse
import errno
import select
import sys

from passport.backend.takeout.common.conf import get_config
from passport.backend.takeout.common.redis import set_key_with_ttl


def is_data_in_stdin():
    return select.select([sys.stdin, ], [], [], 0.0)[0]


def read_task_ids_from_stdin():
    if is_data_in_stdin():
        return {line.strip() for line in sys.stdin}
    return set()


def make_redis_revoke_key(task_id):
    return 'takeout:extract:revoke:task_id:{}'.format(task_id).lower()


def revoke_task(task_id, skip_errors=False):
    ttl = get_config()['revoke_ttl']
    set_key_with_ttl(make_redis_revoke_key(task_id), '1', ttl, skip_errors=skip_errors)


def to_stdout(line):
    try:
        sys.stdout.write(line)
    except IOError as e:
        if e.errno == errno.EPIPE:
            sys.exit(0)
        else:
            raise


def build_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('task_ids', nargs='*')

    return parser.parse_args()


def run_app():
    args = build_parser()
    task_ids = set(args.task_ids or []) | read_task_ids_from_stdin()

    for task_id in task_ids:
        to_stdout('Revoking {}... '.format(task_id))
        revoke_task(task_id, skip_errors=False)
        to_stdout('ok\n')
