# -*- coding: utf-8 -*-
import argparse
import logging
import sys

from passport.backend.takeout.common.conf.signatures import get_keys_for_signing
from passport.backend.takeout.common.signatures import (
    check_signature,
    sign,
)


root = logging.getLogger()
root.setLevel(logging.DEBUG)

handler = logging.StreamHandler(sys.stdout)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
root.addHandler(handler)


def run_app():
    keys = get_keys_for_signing()

    parser = argparse.ArgumentParser()
    parser.add_argument('-kv', '--key-version', choices=list(keys))
    parser.add_argument('-s', '--salt', default=None)
    parser.add_argument('args_to_sign', metavar='A', nargs='+', help='a list of arguments to sign')

    args = parser.parse_args()

    sys.stderr.write(
        'Signing {} with key of version {} and salt {}\n'.format(
            repr(args.args_to_sign),
            repr(args.key_version),
            repr(args.salt),
        ),
    )
    signature = sign(args.args_to_sign, key_version=args.key_version, keys=keys, salt=args.salt)
    print(signature)
    check_signature(args.args_to_sign, signature)
