# -*- coding: utf-8 -*-
import argparse
import os

from passport.backend.takeout.common.conf import configure_settings
from passport.backend.takeout.common.utils import (
    download_from_s3_and_decrypt,
    maybe_make_dirs,
)


def expand_path(path):
    return os.path.abspath(path)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('uid', type=int)
    parser.add_argument('extract_id')
    parser.add_argument('-d', '--dest', default=expand_path('.'))
    args = parser.parse_args()
    return args


def run_app():
    configure_settings()

    args = parse_args()

    data_folder = os.path.join(
        expand_path(args.dest),
        str(args.uid),
        str(args.extract_id),
    )

    maybe_make_dirs(data_folder)

    download_from_s3_and_decrypt(args.uid, args.extract_id, destination_folder=data_folder)
